// AJAXLib v. 1.0
// author: Jacek Karaszewski, http://www.karaszewski.com/tools/ajaxlib/
// licenced under Creative Commons Attribution 2.5 License
// 25/11/09  Rob Munro - NameSpaced to AJAXLib. added getAttribute, getText
// public
var AJAXLib={}
AJAXLib.NODETYPE_TEXT=3;
AJAXLib.NODETYPE_ATTRIBUTE=2;
AJAXLib.NODETYPE_ELEMENT=1;
AJAXLib.functionToCall =0; // callback fn
AJAXLib.xmlRequestObj=0;
AJAXLib.stripWS = 0;
AJAXLib.resultXML = 0;
// function loadXMLDoc(xml_url, function_name, ignore_white)
AJAXLib.loadXMLDoc=function(/*URL*/ url, /*function*/ callFunc, /*boolean*/ ignoreWhite) {
	AJAXLib.functionToCall = callFunc;
	AJAXLib.stripWS = AJAXLib.ignoreWhite;
	AJAXLib.xmlRequestObj = window.XMLHttpRequest?new XMLHttpRequest():new ActiveXObject("Microsoft.XMLHTTP")
	AJAXLib.xmlRequestObj.onreadystatechange = AJAXLib.proccessXML;
	AJAXLib.xmlRequestObj.open("GET", url, true);
	AJAXLib.xmlRequestObj.send(null);
}
// private
AJAXLib.is_ws=function(/*XMLNode*/ nod) {
	return !(/[^\t\n\r ]/.test(nod.data));
}

AJAXLib.findWhiteSpace=function(/*XMLNode*/ node, /*int*/ nodeNo) {
	for (i=0; i<node.childNodes.length; i++) {
		if (node.childNodes[i].nodeType == AJAXLib.NODETYPE_TEXT && AJAXLib.is_ws(node.childNodes[i])) {
			nodesToDelete[nodesToDelete.length] = node.childNodes[i]
		}
		if (node.childNodes[i].hasChildNodes()) {
			AJAXLib.findWhiteSpace(node.childNodes[i], i);
		}
	}
	// what does this do?
	node = node.parentNode;
	i = nodeNo;
}

AJAXLib.stripWhiteSpace =function(/*XMLNode*/ node) {
	nodesToDelete = Array();
	AJAXLib.findWhiteSpace(node, 0);
	for(i=nodesToDelete.length-1;i>=0;i--) {
		nodeRef = nodesToDelete[i];
		nodeRef.parentNode.removeChild(nodeRef)
	}
}

AJAXLib.proccessXML=function() {
	if (AJAXLib.xmlRequestObj.readyState == 4 && (AJAXLib.xmlRequestObj.status == 200 || AJAXLib.xmlRequestObj.status == 304 || AJAXLib.xmlRequestObj.status == 0)) {
		if(AJAXLib.stripWS) {
			AJAXLib.stripWhiteSpace(AJAXLib.xmlRequestObj.responseXML);
		}
		AJAXLib.resultXML = AJAXLib.xmlRequestObj.responseXML;
		if (AJAXLib.functionToCall) {
			AJAXLib.functionToCall()
		}
	}
}
AJAXLib.getAttribute=function(node,attName) {
	for (var attIndex=0; attIndex<node.attributes.length;attIndex++) {
		var att = node.attributes[attIndex];
		if (att.nodeName==attName) {
			return att.nodeValue;
		}
	}
}
AJAXLib.getText=function(node) {
	var text = "";
	for (var i=0;i<node.childNodes.length;i++) {
		var childNode = node.childNodes[i];
		if (childNode.nodeType == AJAXLib.NODETYPE_TEXT) {
			text+=node.childNodes[i].nodeValue;
		}
	}
	return text;
}

