var Player = {}
Player.STATE_STOPPED=0;
Player.STATE_PLAYING=1;
Player.STATE_PAUSED=2;
Player.STATE_SEEKING=3;
Player.STATE_BUFFERING=4;
Player.STATE_ERROR=5;

Player.CONN_TIMEOUT=8000;

Player.timers={}
Player.init=function () {
	
	for (var i=0;i<2;i++) {
		var prefix=(i==0)?"fg":"bg";
		Player.initUnit(prefix);
	}
}

Player.initUnit = function(prefix) {
	Player.initPlayerDialog(prefix);
	$('#'+prefix+'_vol').slider({
		range: false,
		value: 0,
		min:0,
		max:100,
		change: function(event, ui) {
			Player.vol(prefix,ui.value);
		}
	});
	$('#'+prefix+'_posslider').slider({
		range: false,
		value: 0,
		min:0,
		max:100,
		change: function(event, ui) {
			Player.pos(prefix,ui.value);
		}
	});
	
	Player.info(prefix);
	Player.time(prefix);
	Player.timers[prefix+"_info"]=setInterval("Player.info('"+prefix+"')",30000);
	Player.timers[prefix+"_time"]=setInterval("Player.time('"+prefix+"')",5000);
}
Player.initPlayerDialog=function(prefix) {
	//if (!$.browser.msie) {
		var topPos=(prefix=='fg'?70:330);
		$('#'+prefix+'_player_dialog').dialog({
			autoOpen: prefix=='fg',
			width: 440,
			height: $.browser.msie?400:260,
			bgiframe:true,
			show:"blind",
			hide: "blind",
			resizable: false,
			position: [parseInt($("body").innerWidth())-440-16,topPos] ,//
			buttons: { },
			beforeclose: function(event, ui) { $('#'+prefix+'_player_button').empty().append("Show "+(prefix=='fg'?"Foreground":"Background")+" Player") }
		});
	//}
	//scroll the message box to the top offset of browser's scroll bar
	if (prefix=='fg') {
		$(window).scroll(function()	{
			$('#fg_player_dialog').parent().animate({top:($(window).scrollTop()+70)+"px" },{queue: false, duration: 350});
		});
	} else if (prefix=='bg') {
		$(window).scroll(function()	{
			$('#bg_player_dialog').parent().animate({top:($(window).scrollTop()+350)+"px" },{queue: false, duration: 350});
		});
	}
}
Player.toggle=function(prefix) {
	var playerWin = $('#'+prefix+'_player_dialog');
	var text="Hide";
	if (!playerWin.dialog('isOpen')) {
		playerWin.dialog('open');
	} else {
		text="Show";
		playerWin.dialog('close'); 
	}
	 $('#'+prefix+'_player_button').empty().append(text+" "+(prefix=='fg'?"Foreground":"Background")+" Player");
}
Player.stopTimers=function () {
	clearInterval(Player.timers["fg_info"]);
	clearInterval(Player.timers["bg_info"]);
	clearInterval(Player.timers["fg_time"]);
	clearInterval(Player.timers["bg_time"]);
}

Player.info = function (prefix) {
	var prefix
	$.getJSON("?command=player&action=info&prefix="+prefix,
			{prefix:prefix},
		    function(data){
				if (data && data.mpw && data.mpw.file) {
					Player.displayState(data.mpw.state,data.prefix);
					$("#"+data.prefix+"_status").empty().append(data.mpw.status);
					$("#"+data.prefix+"_fileName").val(data.mpw.file.title );
					$("#"+data.prefix+"_pos").empty().append(Util.formatHHMMSS(data.mpw.position));
					$("#"+data.prefix+"_dur").empty().append(Util.formatHHMMSS(data.mpw.duration));
					$("#"+data.prefix+"_feed").empty().append(data.mpw.file.feedTitle);
					$("#"+data.prefix+"_type").empty().append(data.mpw.file.type);
					var feedImgSrc = data.feedImg
					if (!data.feedImg) {
						feedImgSrc = "/drawable/rss_128.png";
						if (data.type=="atom") {feedImgSrc = "/drawable/atom_128.png"}
						else if (data.type=="html") {feedImgSrc = "/drawable/world_128.png"}
					}
					$("#"+data.prefix+"_feedimg").attr("src",feedImgSrc);
					$("#"+data.prefix+"_feedimg").css("visibility","visible");
					if (data.buffered>0 && data.buffered<100) {
						$("#"+data.prefix+"_buf").empty().append(data.mpw.buffered+"%");
						$("#"+data.prefix+"_buf").css("visibility","visible");
					} else {
						$("#"+data.prefix+"_buf").css("visibility","hidden");
					}
					//$("#"+data.prefix+"_buf").css("visibility","visible");
					
				} else {
					Player.displayState(0,prefix);
					$("#"+data.prefix+"_status").empty().append("No Data");
					$("#"+data.prefix+"_fileName").val("");
					$("#"+data.prefix+"_pos").empty().append("");
					$("#"+data.prefix+"_dur").empty().append("");
					$("#"+data.prefix+"_feed").empty().append("");
					$("#"+data.prefix+"_type").empty().append("");
					$("#"+data.prefix+"_feedimg").css("visibility","hidden");
					$("#"+data.prefix+"_buf").css("visibility","hidden");
					$("#"+data.prefix+"_seek").empty().append("No Data");
				}
				if (data.mpw) {
					$("#"+data.prefix+"_skiptime_back").empty().append(data.mpw.skipLengths[data.mpw.skipbLengthPos]);
					$("#"+data.prefix+"_skiptime_fwd").empty().append(data.mpw.skipLengths[data.mpw.skipfLengthPos]);
				}
		    });
}
Player.timeChecking = false;
Player.timeTimeout = -1;
Player.time = function (prefix) {
	if (Player.timeChecking) {return}
	if (Player.timeTimeout>0) {
		clearTimeout(Player.timeTimeout);
		Player.timeTimeout=0;
	}
	Player.timeTimeout=setTimeout("Player.commError('"+prefix+"');",Player.CONN_TIMEOUT);

	Player.timeChecking=true;
	$.getJSON("?command=player&action=time&prefix="+prefix,
		{prefix:prefix},
	    function(data){
			if (Player.timeTimeout>0) {
				clearTimeout(Player.timeTimeout);
				Player.timeTimeout=0;
			}
			if (data) {
				Player.displayState(data.state,data.prefix);
				$("#"+data.prefix+"_status").empty().append(data.status);
				$("#"+data.prefix+"_pos").empty().append(Util.formatHHMMSS(data.pos));
				$("#"+data.prefix+"_dur").empty().append(Util.formatHHMMSS(data.dur));
				$("#"+data.prefix+"_vol").slider('option','value', parseInt(data.vol*100));
				if (data.buffered>0 && data.buffered<100) {
					$("#"+data.prefix+"_buf").empty().append(data.buffered+"%");
					$("#"+data.prefix+"_buf").css("visibility","visible");
				} else {
					$("#"+data.prefix+"_buf").css("visibility","hidden");
				}
				var value = 0;
				if (data.dur!=0) {
					value = parseInt(data.pos/data.dur*100);
				}
				$("#"+data.prefix+"_posslider").slider('option','value',value );
			} else {
				Player.displayState(0,prefix);
				$("#"+data.prefix+"_status").empty().append("No Data");
				$("#"+data.prefix+"_pos").empty().append("");
				$("#"+data.prefix+"_dur").empty().append("");
				$("#"+data.prefix+"_vol").slider('option','value',0);
				$("#"+data.prefix+"_posslider").slider('option','value',0);
				$("#"+data.prefix+"_buf").css("visibility","hidden");
				$("#"+data.prefix+"_seek").empty().append("No Data");

			}
			Player.timeChecking=false;
	});
}
Player.commError=function(prefix) {
	//$("#"+prefix+"_status").empty().append("Communication Error");
	Util.showError(["Communication error"]);
	Player.timeTimeout=-1;
}
Player.displayState=function(state,prefix){
	var playSrc = "/drawable/butt_play_off.png";
	var pauseSrc = "/drawable/butt_pause_off.png";
	seekText="Not Playing";
	if (state==Player.STATE_PLAYING) {
		playSrc = "/drawable/butt_play_on.png";
		pauseSrc = "/drawable/butt_pause_off.png";
		seekText="Playing";
	} else if (state==Player.STATE_PAUSED) {
		playSrc = "/drawable/butt_play_off.png";
		pauseSrc = "/drawable/butt_pause_on.png";
		seekText="Paused";
	} else if (state==Player.STATE_SEEKING) {
		playSrc = "/drawable/butt_play_on.png";
		pauseSrc = "/drawable/butt_pause_off.png";
		seekText="Seeking";
	} else if (state==Player.STATE_STOPPED) {
		playSrc = "/drawable/butt_play_off.png";
		pauseSrc = "/drawable/butt_pause_off.png";
		seekText="Stopped";
	} else if (state==Player.STATE_ERROR) {
		playSrc = "/drawable/butt_play_off.png";
		pauseSrc = "/drawable/butt_pause_off.png";
		seekText="Error";
	} else if (state==Player.STATE_BUFFERING) {
		playSrc = "/drawable/butt_play_on.png";
		pauseSrc = "/drawable/butt_pause_off.png";
		seekText="Buffering";
	} 
	$("#"+prefix+"_play_but").attr("src",playSrc);
	$("#"+prefix+"_pause_but").attr("src",pauseSrc);
	$("#"+prefix+"_seek").empty().append(seekText);
	
}
Player.play = function (prefix) {
	$.getJSON("?command=player&action=play&prefix="+prefix,
    function(data){
		if (data.error.length>0) {
			Util.showError(data.error);
		}
		Player.info(prefix);
    });
}
Player.volChanging = false;
Player.vol = function (prefix,newVol) {
	if (Player.volChanging) return; 
	Player.volChanging = true;
	$.getJSON("?command=player&action=vol&prefix="+prefix+"&value="+newVol,
    function(data){
		if (data.error.length>0) {
			Util.showError(data.error);
		}
		setTimeout("Player.time();",300);
		Player.volChanging = false;
    });
}
Player.posChanging = false;
Player.pos = function (prefix,newPos) {
	if (Player.posChanging) return; 
	Player.posChanging = true;
	$.getJSON("?command=player&action=pos&prefix="+prefix+"&value="+newPos,
    function(data){
		if (data.error.length>0) {
			Util.showError(data.error);
		}
		setTimeout("Player.time();",300);
		Player.posChanging = false;
    });
}
Player.playFile = function (prefix,obj) {
	var id = Feed.getId(obj);
	$.getJSON("?command=player&action=play&prefix="+prefix+"&file="+id,
    function(data){
		$("#"+data.prefix+"_status").empty().append(data.result);
		Player.info(data.prefix);
    });
}
Player.pause = function (prefix) {
	$.getJSON("?command=player&action=pause&prefix="+prefix,
    function(data){
		if (data.error.length>0) {
			Util.showError(data.error);
		}

    });
}
Player.skipb = function (prefix) {
	$.getJSON("?command=player&action=skipb&prefix="+prefix,
    function(data){
		if (data.error.length>0) {
			Util.showError(data.error);
		}

    });
}
Player.skipf = function (prefix) {
	$.getJSON("?command=player&action=skipf&prefix="+prefix,
    function(data){
		if (data.error.length>0) {
			Util.showError(data.error);
		}

    });
}
Player.next = function (prefix) {
	$.getJSON("?command=player&action=next&prefix="+prefix,
    function(data){
		if (data.error.length>0) {
			Util.showError(data.error);
		}
		setTimeout("Player.info();Player.time();",800);
		
    });
}
Player.last = function (prefix) {
	$.getJSON("?command=player&action=last&prefix="+prefix,
    function(data){
		if (data.error.length>0) {
			Util.showError(data.error);
		}
		setTimeout("Player.info();Player.time();",800);
    });
}
Player.addPlayList = function (prefix,obj) {
	var id = Feed.getId(obj);
	$.getJSON("?command=player&action=addplaylist&prefix="+prefix+"&file="+id,
	function(data){
		if (data.error.length>0) {
			Util.showError(data.error);
		}
	});
}
Player.stream=function(file,prefix){
	var encoded = File.prepareFileForAJAX(file);
	Util.showLoading();
	$.post("?command=player&action=stream&prefix="+prefix,
		{file:encoded},
		function(data){
			if (data.error.length>0) {
				Util.showError(data.error);
			}
			setTimeout("Player.info();",600);
			Util.hideLoading();
			//if (callback) {callback();}
		},"json"
	);
}
