var Parser={}
Parser.detectAndParse=function(/*doc*/ xmlDoc){
	if (xmlDoc.getElementsByTagName("channel").length>0){
		return RSSparser.parseFeed(xmlDoc);
	}
	else if (xmlDoc.getElementsByTagName("feed").length>0) {
		return Atomparser.parseFeed(xmlDoc);
	}
	else alert("Could not determine feed type");
	
	return 0;
}

var RSSparser = {};
RSSparser.parseFeed = function( /*doc*/ xmlDoc) {
	var channel = xmlDoc.getElementsByTagName("channel")[0];
	var feed = {};
	feed.files=new Array();
	//feed.url=localFile;
	feed.type="rss";
	for (var i=0;i<channel.childNodes.length;i++) {
		var node = channel.childNodes[i];
		if (node.nodeType==AJAXLib.NODETYPE_ELEMENT) {
			if (node.nodeName=='title') {
				feed.title=AJAXLib.getText(node);continue;
			}
			if (node.nodeName=='description') {
				feed.description=AJAXLib.getText(node);continue;
			}
			if (node.nodeName=='itunes:subtitle' && !feed.description) {
				feed.description=AJAXLib.getText(node);continue;
			}
			if (node.nodeName=='link') {
				feed.link=AJAXLib.getText(node);continue;
			}
			if (node.nodeName=='pubDate') {
				feed.pubDate=AJAXLib.getText(node);continue;
			}
			if (node.nodeName=='itunes:owner') {
				for (var ownerIndex=0; ownerIndex<node.childNodes.length;ownerIndex++) {
					var ownerNode = node.childNodes[ownerIndex];
					if (ownerNode.nodeType==AJAXLib.NODETYPE_ELEMENT) {
						if (ownerNode.nodeName=='itunes:email') {
							feed.email = AJAXLib.getText(ownerNode);continue;
						}
						if (ownerNode.nodeName=='itunes:name') {
							feed.owner = AJAXLib.getText(ownerNode);continue;
						}
						
					}
				}
				continue;
			}
			if (node.nodeName=='image') {
				for (var imgIndex=0; imgIndex<node.childNodes.length;imgIndex++) {
					var imgNode = node.childNodes[imgIndex];
					if (imgNode.nodeType==AJAXLib.NODETYPE_ELEMENT) {
						if (imgNode.nodeName=='url') {
							feed.imgUrl = AJAXLib.getText(imgNode);break;
						}
					}
				}
				continue;
			}
			if (!feed.imgUrl && node.nodeName=='itunes:image') {
				feed.imgUrl=AJAXLib.getAttribute(node,"href");continue;
			}
			if (node.nodeName=='item') {
				feed.files.push(RSSparser.parseItem(node));continue;
			}
		}
		

	}
	if (!feed.imgUrl) {feed.imgUrl="";}
	if (!feed.email) {feed.email="";}
	if (!feed.owner) {feed.owner="";}
	if (!feed.pubDate) {feed.pubDate="";}
	if (!feed.link) {feed.link="";}
	if (!feed.description) {feed.description="";}
	if (!feed.title) {feed.title="";}
	return feed;
}
RSSparser.parseItem= function(/*node*/itemNode) {
	var item = {};
	for (var i=0;i<itemNode.childNodes.length;i++) {
		var node =itemNode.childNodes[i];
		if (node.nodeType==AJAXLib.NODETYPE_ELEMENT) {
			if (node.nodeName=='title') {
				item.title=AJAXLib.getText(node);continue;
			}
			if (node.nodeName=='description') {
				item.description=AJAXLib.getText(node);continue;
			}
			if (node.nodeName=='itunes:subtitle' && !item.description) {
				item.description=AJAXLib.getText(node);continue;
			}
			if (node.nodeName=='pubDate') {
				item.pubDate=AJAXLib.getText(node);continue;
			}
			if (node.nodeName=='link') {
				item.link=AJAXLib.getText(node);continue;
			}
			if (node.nodeName=='enclosure') {
				item.remoteUrl=AJAXLib.getAttribute(node,"url");
				item.type=AJAXLib.getAttribute(node,"type");
				item.size=AJAXLib.getAttribute(node,"length");
				continue;
			}
			// this wont work - need to have array of enclosures
			if (node.nodeName=='media:content') {
				item.remoteUrl=AJAXLib.getAttribute(node,"url");
				item.type=AJAXLib.getAttribute(node,"type");
				item.size=AJAXLib.getAttribute(node,"fileSize");
				item.duration=AJAXLib.getAttribute(node,"duration");
				continue;
			}
			if (node.nodeName=='itunes:explicit') {
				item.explicit=AJAXLib.getText(node);continue;
			}
			if (node.nodeName=='itunes:duration') {
				item.duration=AJAXLib.getText(node);continue;
			}
			if (node.nodeName=='itunes:keywords') {
				item.keywords=AJAXLib.getText(node);continue;
			}
		}
		
	}
	if (!item.title) {item.title="";}
	if (!item.description) {item.description="";}
	if (!item.pubDate) {item.pubDate="";}
	if (!item.link) {item.link="";}
	if (!item.remoteUrl) {item.remoteUrl="";}
	if (!item.type) {item.type="";}
	if (!item.size) {item.size=0;}
	if (!item.explicit) {item.explicit="";}
	if (!item.duration) {item.duration=0;}
	if (!item.keywords) {item.keywords="";}
	return item;
}
var Atomparser = {};
Atomparser.parseFeed = function( /*doc*/ xmlDoc) {
	var channel = xmlDoc.getElementsByTagName("feed")[0];
	var feed = {};
	feed.files=new Array();
	//feed.url=localFile;
	feed.type="atom";
	for (var i=0;i<channel.childNodes.length;i++) {
		var node = channel.childNodes[i];
		if (node.nodeType==AJAXLib.NODETYPE_ELEMENT) {
			if (node.nodeName=='title' && AJAXLib.getAttribute(node,"type")=='text') {
				feed.title=AJAXLib.getText(node);continue;
			}
			if (node.nodeName=='subtitle' && AJAXLib.getAttribute(node,"type")=='html') {
				feed.description=AJAXLib.getText(node);continue;
			}
			if (node.nodeName=='link' && AJAXLib.getAttribute(node,"rel")=='alternate') {
				feed.link=AJAXLib.getAttribute(node,"href");continue;
			}
			if (node.nodeName=='updated') {
				feed.pubDate=AJAXLib.getText(node);continue;
			}
			if (node.nodeName=='author') {
				for (var ownerIndex=0; ownerIndex<node.childNodes.length;ownerIndex++) {
					var ownerNode = node.childNodes[ownerIndex];
					if (ownerNode.nodeType==AJAXLib.NODETYPE_ELEMENT) {
						if (ownerNode.nodeName=='email') {
							feed.email = AJAXLib.getText(ownerNode);continue;
						}
						if (ownerNode.nodeName=='name') {
							feed.owner = AJAXLib.getText(ownerNode);continue;
						}
						
					}
				}
				continue;
			}
			/*
			if (node.nodeName=='image') {
				feed.imgUrl=AJAXLib.getText(node);continue;
			}
			if (!feed.imgUrl && node.nodeName=='itunes:image') {
				feed.imgUrl=AJAXLib.getAttribute(node,"href");continue;
			}
			*/
			if (node.nodeName=='entry') {
				feed.files.push(Atomparser.parseItem(node));continue;
			}
		}
	}
	return feed;
}
Atomparser.parseItem= function(/*node*/itemNode) {
	var item = {};
	for (var i=0;i<itemNode.childNodes.length;i++) {
		var node =itemNode.childNodes[i];
		if (node.nodeType==AJAXLib.NODETYPE_ELEMENT) {
			if (node.nodeName=='title' && AJAXLib.getAttribute(node,"type")=='text') {
				item.title=AJAXLib.getText(node);continue;
			}
			if (node.nodeName=='content') {
				item.description=AJAXLib.getText(node);
				if (AJAXLib.getAttribute(node,"type")=='html') {
					//item.description.replace(/(&gt;)/>/g);
					//item.description.replace(/(&lt;)/</g);
					//item.description.replace(/(&amp;)/&/g);
				}
				continue;
			}
			if (node.nodeName=='published') {
				item.pubDate=AJAXLib.getText(node);continue;
			}
			if (node.nodeName=='link'  && AJAXLib.getAttribute(node,"rel")=='alternate') {
				item.link=AJAXLib.getAttribute(node,"href");continue;
			}
			if (node.nodeName=='link' && AJAXLib.getAttribute(node,"rel")=='enclosure') {
				item.remoteUrl=AJAXLib.getAttribute(node,"href");
				item.type=AJAXLib.getAttribute(node,"type");
				item.size=AJAXLib.getAttribute(node,"length");
				continue;
			}
			/*
			if (node.nodeName=='itunes:explicit') {
				item.explicit=AJAXLib.getText(node);continue;
			}
			if (node.nodeName=='itunes:duration') {
				item.duration=AJAXLib.getText(node);continue;
			}
			if (node.nodeName=='itunes:keywords') {
				item.keywords=AJAXLib.getText(node);continue;
			}
			*/
			item.explicit='';
			item.duration='';
			item.keywords='';
		}
		
	}
	if (!item.title) {item.title="";}
	if (!item.description) {item.description="";}
	if (!item.pubDate) {item.pubDate="";}
	if (!item.link) {item.link="";}
	if (!item.remoteUrl) {item.remoteUrl="";}
	if (!item.type) {item.type="";}
	if (!item.size) {item.size=0;}
	if (!item.explicit) {item.explicit="";}
	if (!item.duration) {item.duration=0;}
	if (!item.keywords) {item.keywords="";}
	return item;
}