File = {}
File.fileCache=[]           
File.FLAG_NONE=					-1;
File.FLAG_MASK_DOWNLOADED=		1;
File.FLAG_MASK_KEEP=			2;
File.FLAG_MASK_DELETED=			4;
File.FLAG_MASK_LISTENED=		8;
File.FLAG_MASK_QUEUED=			16;
File.FLAG_MASK_DL_POWER=		32;
File.FLAG_MASK_DL_WIFI=			64;
File.FLAG_MASK_DL_ERROR=		128;
File.FLAG_MASK_ERROR=			256;
File.FLAG_MASK_AUTODOWNLOADED=	512;

File.flagIcons = {}
File.flagIcons[File.FLAG_MASK_DOWNLOADED]=		"/drawable/icon_dl_20.png";
File.flagIcons[File.FLAG_MASK_KEEP]=			"/drawable/icon_keep_20.png",
File.flagIcons[File.FLAG_MASK_DELETED]=			"/drawable/icon_del_20.png";
File.flagIcons[File.FLAG_MASK_LISTENED]=		"/drawable/icon_play_20.png";
File.flagIcons[File.FLAG_MASK_QUEUED]=			"/drawable/icon_q_20.png";
File.flagIcons[File.FLAG_MASK_DL_POWER]=		"/drawable/icon_power_20.png";
File.flagIcons[File.FLAG_MASK_DL_WIFI]=			"/drawable/icon_wifi_20.png";
File.flagIcons[File.FLAG_MASK_DL_ERROR]=		"/drawable/icon_error_20.png";
File.flagIcons[File.FLAG_MASK_ERROR]=			"/drawable/icon_bl_err_20.png";
File.flagIcons[File.FLAG_MASK_AUTODOWNLOADED]=	"/drawable/icon_dl_auto_20.png"            


File.getFileById= function(id) {
	for (var i=0;i<File.fileCache.length;i++){
		var file = File.fileCache[i];
		if (file.id==id) {return file;}
	}
	return 0;
}                

File.getAllFiles=function() {
	Util.showLoading();
	//$.getJSON("?command=db&action=allfiles",
	$.get("?command=db&action=allfiles",
		function(data){
			data=eval(data);
			if (data.files) {
				File.fileCache=data.files;
				$("div#files").empty();
				for (var i = 0;i<data.files.length;i++) {
					var clone = $("#fileTmpl").children().clone();
					clone.attr("id","file_"+data.files[i].id);
					clone.children().children("div").children("span#_file_id").attr("id",i+"_file_id").append(data.files[i].id);
					clone.children().children("div").children("span#_file_title").attr("id",i+"_file_title").append(data.files[i].title);
					clone.children().children("div").children("span#_file_feedTitle").attr("id",i+"_file_feedTitle").append(data.files[i].feedTitle);
					clone.children().children("div").children("span#_file_flags").attr("id",i+"_file_flags");//.append(data.files[i].flags);
					clone.children().children("img#_file_pl_fg").attr("id",data.files[i].id+"_file_pl_fg");
					clone.children().children("img#_file_pl_bg").attr("id",data.files[i].id+"_file_pl_bg");
					clone.children().children("img#_file_add_fg").attr("id",data.files[i].id+"_file_add_fg");
					clone.children().children("img#_file_add_bg").attr("id",data.files[i].id+"_file_add_bg");
					clone.children().children("img#_file_del").attr("id",data.files[i].id+"_file_del");
					clone.appendTo("div#files");
					File.displayFlagIcons(data.files[i],$("span#"+i+"_file_flags").empty());
					var icon = clone.children("img#_file_icon").attr("id",data.files[i].id+"_file_icon");
					if (data.extra) {
						icon.attr("src",data.extra[i].icon);
					}
				}
			}
			Util.hideLoading();
	//}
	},"json"
	);
}

File.queueFile=function(file,callback){
	if (!file.name) {file.name="";}
	if (!file.flags) {file.flags=0;}
	if (!file.rating) {file.rating=0;}
	var encoded = $.toJSON(file);
	Util.showLoading();
	$.post("?command=db&action=queue",
		{file:encoded},
		function(data){
			if (data.result=='ok') {
				Util.showMessage("download queued");
			} 
			if (data.error.length>0) {
				Util.showError(data.error);
			}
			Util.hideLoading();
			if (callback) {callback();}
		},"json"
	);
}

File.deleteFile=function(obj) {
	//alert("not implemented:"+ Feed.getId(obj));
	var id = Feed.getId(obj);
	var file = File.getFileById(id)
	if (file) {
		$('#delete_dialog_msg').empty().append("Do you want to delete the feed "+file.title+" and all downloaded files?")
		Feed.deleteFunction=function() { File.deleteOK(obj); }
		$('#delete_dialog').dialog('open');
	} else {
		Util.showError(["Invalid file number"]);
	}
}
File.deleteOK = function (obj) {
	var id = Feed.getId(obj);
	Util.showLoading();
	$.getJSON("?command=player&action=deleteFile&file="+id,
	function(data){
		if (data.error.length>0) {
			Uril.showErrors(data.error);
		} 
		File.getAllFiles();
		Util.hideLoading();
	});
}
File.prepareFileForAJAX= function (file){
	if (!file.name) {file.name="";}
	if (!file.flags) {file.flags=0;}
	if (!file.rating) {file.rating=0;}
	return $.toJSON(file);
}
File.getFlagIcons=function(file,jQuerySel){
	//get file rec from server by url if no id
	var encoded = File.prepareFileForAJAX(file);
	Util.showLoading();
	$.post("?command=db&action=checkFile",
		{file:encoded},
		function(data){
			if (data.file) {
				if (jQuerySel) {
					File.displayFlagIcons(data.file,jQuerySel);
				}
			} 
			if (data.error.length>0) {
				Util.showError(data.error);
			}
			Util.hideLoading();
			//if (callback) {callback();}
		},"json"
	);
}
File.displayFlagIcons=function(file,jQuerySel){
	$.each(File.flagIcons, function(key) {
		if (Feed.getFlag(file,key)) {
			jQuerySel.append('<img src="'+File.flagIcons[key]+'" border="0"/>');
		}
	});
}
File.dlClientFile=function(obj) {
	var id = Feed.getId(obj);
	var url ="/?command=stream&fileid="+id+"&dl=true&block="+(new Date()).getTime();
	document.location = url;
}

File.stClientFile=function(obj) {
	var id = Feed.getId(obj);
	var url ="/?command=stream&fileid="+id+"&block="+(new Date()).getTime();
	window.open(url,"_blank");
	
}


