Feed={}
Feed.feedCache=[];// list of feed last loaded
Feed.allTags=[];// list of tags last loaded
Feed.tagMap={};// tags hashed by ID
//////////////////// flag defs //////////////////////////////
Feed.FLAG_NONE				=		-1;
Feed.FLAG_MASK_HASNEW		=		1;
//Feed.FLAG_MASK_UPDAUTO 	= 		2;
Feed.FLAG_MASK_DLAUTO 		= 		4;
Feed.FLAG_MASK_DLPWRCHK 	= 		8;
Feed.FLAG_MASK_DLWIFICHK 	= 		16;
/////////////// ID utils ///////////////////////////////////
Feed.DROP_HEIGHT="600px";
Feed.NO_DROP_HEIGHT="130px";

Feed.getId=function(obj){
	return obj.id.substring(0,obj.id.indexOf("_"));
}
Feed.getFeedById= function(id) {
	for (var i=0;i<Feed.feedCache.length;i++){
		var feed = Feed.feedCache[i];
		if (feed.id==id) {return feed;}
	}
	return 0;
}
/////////////// end ID utils ///////////////////////////////////

//////////////flags stuff ////////////////////////
Feed.getFlag=/*boolean*/function(feed,mask) {
	return (feed.flags&mask) != 0;
}
Feed.setFlag=function(feed,mask,/*boolean*/value) {
	if (value) {
		feed.flags = (feed.flags | mask);
	} else {
		feed.flags = (feed.flags & ~mask);
	}
}
////////////// end flags stuff ////////////////////////

////////////// init functions /////////////////////////
Feed.deleteFunction=0;
Feed.initMisc = function(){
	// delete dialog
	$('#delete_dialog').dialog({
		autoOpen: false,
		width: 300,
		height: 200,
		modal: true,
		buttons: {
			"Ok": function() { 
				if (Feed.deleteFunction) {
					Feed.deleteFunction();
				}
				$(this).dialog("close"); 
			}, 
			"Cancel": function() { 
				$(this).dialog("close"); 
			} 
		}
	});
	$('#item_description_dialog').dialog({
		autoOpen: false,
		width: 700,
		height: 500,
		modal: true,
		buttons: {
			"Ok": function() { 
				$(this).dialog("close"); 
			}, 
			"Cancel": function() { 
				$(this).dialog("close"); 
			} 
		}
	});
	$('#download_dialog').dialog({
		autoOpen: false,
		width: 500,
		height: 250,
		modal: true,
		buttons: {
			"Ok": function() { 
				if (Feed.downloadFile) {
					var file = Feed.downloadFile;
					Feed.downloadFile.title= $("#download_title_text").val();
					if (!file.flags) {file.flags=0;} 
					Feed.setFlag(Feed.downloadFile,File.FLAG_MASK_DL_POWER, $("#download_power_chk").val())
					File.queueFile(Feed.downloadFile);
					var feedJQ=$("#"+Feed.currentViewFeed.feedId+"_"+Feed.downloadItemIndex+"_item_body");
					feedJQ.css("background","#440000");
					Feed.downloadFile=0;
					Feed.downloadItemIndex=-1;
				}
				$(this).dialog("close"); 
			}, 
			"Cancel": function() { 
				Feed.downloadFile=0;
				Feed.downloadItemIndex=-1;
				$(this).dialog("close"); 
				
			} 
		}
	});
}
//////////////intit functions /////////////////////////

//////////////// transport functions /////////////////////////////
Feed.getAllFeeds=function(callback) {
	Util.showLoading();
	$.getJSON("?command=db&action=allfeeds",
		function(data){
			if (data.feeds) {
				Feed.feedCache=data.feeds;
				$("div#feeds").empty();
				for (var i = 0;i<data.feeds.length;i++) {
					var id = data.feeds[i].id;
					var clone = $("#feedTmpl").children().clone();
					clone.attr("id","feed_"+data.feeds[i].id);
					var typesrc = "/drawable/rss_128.png";
					if (data.feeds[i].type=="atom") {typesrc = "/drawable/atom_128.png"}
					else if (data.feeds[i].type=="html") {typesrc = "/drawable/world_128.png"}
					clone.children().children("img#_feed_image").attr("id",id+"_feed_image").attr("src",data.feeds[i].imgUrl?data.feeds[i].imgUrl:typesrc);
					clone.children().children().children("span#_feed_id").attr("id",id+"_feed_id").append(id);
					clone.children().children().children("span#_feed_title").attr("id",id+"_feed_title").append(data.feeds[i].title);
					clone.children().children().children("a#_feed_link").attr("id",id+"_feed_link").attr("href",data.feeds[i].link).append(data.feeds[i].link);
					clone.children().children().children("span#_feed_url").attr("id",id+"_feed_url").append(data.feeds[i].url);
					clone.children().children().children("span#_feed_desc").attr("id",id+"_feed_desc").append(data.feeds[i].description);
					clone.children().children("img#_feed_ed").attr("id",id+"_feed_ed");//edit
					clone.children().children("img#_feed_em").attr("id",id+"_feed_em");//send
					clone.children().children("img#_feed_re").attr("id",id+"_feed_re");//reload
					clone.children().children("img#_feed_de").attr("id",id+"_feed_de");//delete
					clone.children("div#_editfeed").attr("id",id+"_editfeed");
					clone.children("div#_viewfeed").attr("id",id+"_viewfeed");
					clone.appendTo("div#feeds");
					
				}
			}
			if (data.error.length>0) {
				Util.showError(data.error);
			}
			Util.hideLoading();
			if (callback) {callback();	}
	});
}

Feed.getAllTags=function(callback) {
	Util.showLoading();
	$.getJSON("?command=db&action=alltags",
		function(data){
			if (data.tags) {
				Feed.allTags=data.tags;
				var tagMap = {};
				$.each(Feed.allTags,function(i){
					var tag = Feed.allTags[i];
					tagMap[tag.id]=tag;
				});
				Feed.tagMap=tagMap;
				if (callback) {callback();}
			}
			if (data.error.length>0) {
				Util.showError(data.error);
			}
			Util.hideLoading();
	});
}
Feed.addTagCall=function(tag) {
	Util.showLoading();
	$.getJSON("?command=db&action=addtag&value="+tag,
		function(data){
			if (data.result=='ok') {
				Feed.getAllTags(
						function() {
							Feed.populateTagList();
						}
				);
			} 
			if (data.error.length>0) {
				Util.showError(data.error);
			}
			Util.hideLoading();
	});
}
Feed.saveFeed=function(feed,callback) {
	var encoded = $.toJSON(feed);
	Util.showLoading();
	$.post("?command=db&action=saveFeed",
		{feed:encoded},
		function(data){
			if (data.result=='ok') {
				$("div#feeds").empty();
				Feed.getAllFeeds();
				Util.showMessage("Feed Saved.");
			} 
			if (data.error.length>0) {
				Util.showError(data.error);
			}
			Util.hideLoading();
			if (callback) {callback();}
		},"json"
	);
}
Feed.doDelete=function(obj) {
	var id = Feed.getId(obj);
	var feed = Feed.getFeedById(id);
	Util.showLoading();
	$.getJSON("?command=db&action=deleteFeed&id="+feed.id,
		function(data){
			if (data.result=='ok') {
				Util.showMessage("Feed deleted.");
				Feed.getAllFeeds();
				File.getAllFiles();
			} 
			if (data.error.length>0) {
				Util.showError(data.error);
			}
			Util.hideLoading();
	});
	
}
//////////////// end transport functions /////////////////////////////


/////////////// edit stuff ///////////////////////////////////
Feed.edit = function(obj) {
	var id = Feed.getId(obj);
	Feed.hideLast(obj);
	if (!Feed.currentViewFeed  || Feed.currentViewFeed.feedId!=id) {
		Feed.setCurrrentViewFeed(0,id);
	}
	$("div#"+id+"_viewfeed").css("display","none");

	if ($("div#"+id+"_editfeed").children().length>0) {
		var show = $("div#"+id+"_editfeed").css("display")=="none";
		if (show) {
			$("div#feed_"+id).css({"height":Feed.DROP_HEIGHT});
			$("div#"+id+"_editfeed").css("display","block");
			Util.scrollToView("div#feed_"+id);
		} else {
			$("div#feed_"+id).css({"height":Feed.NO_DROP_HEIGHT});
			$("div#"+id+"_editfeed").css("display","none");
		}
	} else {
		var clone = $("#editTmpl").children().clone();
		var feed = Feed.getFeedById(id);
		Feed.populateEdit(clone,id,feed);
		clone.appendTo("div#"+id+"_editfeed");
		$("div#feed_"+id).css({"height":Feed.DROP_HEIGHT,"display":"block"});
		$("div#"+id+"_editfeed").css("display","block");
		Util.scrollToView("div#feed_"+id);
	}
	
}
Feed.refreshEdit=function(feed){
	//
	$("div#"+feed.id+"_editfeed").empty();
	var clone = $("#editTmpl").children().clone();
	Feed.populateEdit(clone,feed.id,feed);
	clone.appendTo("div#"+feed.id+"_editfeed");
	$("div#feed_"+feed.id).css({"height":Feed.DROP_HEIGHT,"display":"block"});
}

Feed.populateEdit=function(nodeRoot,id,feed) {
	if (id!="add") {
		nodeRoot.children("div#_efeed_banner").attr("id",id+"_efeed_banner").empty().append("Add feed");
	}
	nodeRoot.children("span#_efeed_title").attr("id",id+"_efeed_title").append(feed.title);
	nodeRoot.children("span#_efeed_desc").attr("id",id+"_efeed_desc").append(feed.description);
	nodeRoot.children("span#"+id+"_efeed_desc").parent().height(50);//clone.children("span#"+id+"_efeed_desc").outerHeight()
	nodeRoot.children("#_efeed_url").attr("id",id+"_efeed_url").val(feed.url);
	nodeRoot.children("span#_efeed_type").attr("id",id+"_efeed_type").empty().append(feed.type);
	var typesrc = "/drawable/rss_32.png";
	if (feed.type=="atom") {typesrc = "/drawable/atom_32.png"}
	else if (feed.type=="html") {typesrc = "/drawable/world_32.png"}
	nodeRoot.children("img#_efeed_type_img").attr("id",id+"_efeed_type_img").attr("src",typesrc);
	nodeRoot.children("select#_efeed_rating").attr("id",id+"_efeed_rating").val(parseInt(feed.rating));
	nodeRoot.children("select#_efeed_updinterval").attr("id",id+"_efeed_updinterval").val(parseInt(feed.updInterval));
	nodeRoot.children("select#_efeed_maxload").attr("id",id+"_efeed_maxload").val(parseInt(feed.maxItems));
	nodeRoot.children("input#_efeed_autodl").attr("id",id+"_efeed_autodl").attr("checked",Feed.getFlag(feed,Feed.FLAG_MASK_DLAUTO ));// read flags
	nodeRoot.children("select#_efeed_numkeep").attr("id",id+"_efeed_numkeep").val(parseInt(feed.numKeep));
	nodeRoot.children("input#_efeed_dlpower").attr("id",id+"_efeed_dlpower").attr("checked",Feed.getFlag(feed,Feed.FLAG_MASK_DLPWRCHK ));// read flags
	nodeRoot.children("input#_efeed_dlwifi").attr("id",id+"_efeed_dlwifi").attr("checked",Feed.getFlag(feed,Feed.FLAG_MASK_DLWIFICHK ));// read flags
	nodeRoot.children("#_efeed_user").attr("id",id+"_efeed_user").val(feed.username);
	nodeRoot.children("#_efeed_pass").attr("id",id+"_efeed_pass").val(feed.password);
	//fill tags
	nodeRoot.children("span#_efeed_tags").attr("id",id+"_efeed_tags").empty();
	for (var i=0;i<feed.tags.length;i++) {
		tag=feed.tags[i];
		var tagClone = $("#tagTmpl").children().clone();
		tagClone.attr("id",tag.id+"_tag").empty().append(tag.tag);
		nodeRoot.children("span#"+id+"_efeed_tags").append(tagClone);
	}
	nodeRoot.children().children("img#_efeed_tagSel").attr("id",id+"_efeed_tagSel");// tags but
	nodeRoot.children("img#_efeed_cancel").attr("id",id+"_efeed_cancel");// cancel but
	nodeRoot.children("img#_efeed_save").attr("id",id+"_efeed_save");// save but
	nodeRoot.children().children("img#_efeed_check").attr("id",id+"_efeed_check").css("visibility",(id!="add")?"hidden":"visible");
}
/////////////// end edit stuff ///////////////////////////////////

////////////// tags stuff ////////////////////////
Feed.feedTagging = 0;
Feed.openTags=function(obj) {
	var feedid = Feed.getId(obj);
	if (feedid!='add') {
		var feed = Feed.getFeedById(feedid);
		Feed.feedTagging=feed;
	} else {
		Feed.feedTagging=Feed.addFeedTmp;
	}
	Feed.populateTagList();
	$('#tags_dialog').dialog('open');
}
Feed.populateTagList=function() {
	$("div#tags_dialog_tags").empty();
	for (var i = 0;i<Feed.allTags.length;i++) {
		var id = Feed.allTags[i].id;
		var clone = $("#tagRowTmpl").children().clone();
		clone.attr("id",id+"_tag");
		clone.children().children("input#_tag_chk").attr("id",id+"_tag_chk").attr("checked",Util.contains(Feed.feedTagging.tags,"id",Feed.allTags[i].id));
		clone.children().children("span#_tag_text").attr("id",id+"_tag_text").append(Feed.allTags[i].tag);
		clone.appendTo("div#tags_dialog_tags");
	}
}
Feed.selectTags=function(obj) {
	var selectedTags=new Array();
	$("div#tags_dialog_tags").children().children().children("input").each(function (node) {
		if (this.checked) {
			selectedTags.push(Feed.tagMap[Feed.getId(this)]);
		}
	});
	Feed.feedTagging.tags=selectedTags;
	if (Feed.feedTagging == Feed.addFeedTmp) {
		Feed.updateFeedObject(Feed.feedTagging,"add");
		Feed.refreshAdd(Feed.feedTagging);
	} else {
		Feed.updateFeedObject(Feed.feedTagging,Feed.feedTagging.id);
		Feed.refreshEdit(Feed.feedTagging);
	}
	Feed.feedTagging=0;
}

Feed.addTag=function(obj) {
	var newTag = $("#tags_dialog_add_text").val();
	if (newTag) {
		Feed.addTagCall(newTag);
		$("#tags_dialog_add_text").val("");
	} else {
		Util.showError(["Please enter a tag name."]);
	}
}

Feed.initTagDialog=function() {
	$('#tags_dialog').dialog({
		autoOpen: false,
		width: 400,
		modal: true,
		buttons: {
			"Ok": function() { 
				Feed.selectTags();
				$(this).dialog("close"); 
			}, 
			"Cancel": function() { 
				Feed.feedTagging=0;
				$(this).dialog("close"); 
			} 
		}
	});
}
////////////// end tags stuff ////////////////////////

/////////////// button handlers //////////////////////////
Feed.send=function(obj) {
	alert("not implemented:"+ Feed.getId(obj));
}
Feed.hideLast=function(obj){
	var id = Feed.getId(obj);
	if (Feed.currentViewFeed && Feed.currentViewFeed.feedId!=id) {
		$("div#"+Feed.currentViewFeed.feedId+"_viewfeed").css("display","none");
		$("div#"+Feed.currentViewFeed.feedId+"_editfeed").css("display","none");
		$("div#feed_"+Feed.currentViewFeed.feedId).css({"height":Feed.NO_DROP_HEIGHT});
	}
}
Feed.refresh=function(obj) {
	var id = Feed.getId(obj);
	feed = Feed.getFeedById(id);
	if (feed.type=="html") {window.open(feed.url,"_blank");return;}
	Feed.hideLast(obj);
	$("div#"+id+"_editfeed").css("display","none");
	if ((Feed.currentViewFeed && Feed.currentViewFeed.feedId!=id) || !Feed.currentViewFeed|| !Feed.currentViewFeed.parsedFeed) {
		Util.showLoading();
		Feed.setCurrrentViewFeed(0,id);
		AJAXLib.loadXMLDoc("?command=get&type=text/xml&url="+escape(feed.url),function () {Feed.parseAndRender(obj)},true);
		Feed.currentViewFeed=0;
	} else if (Feed.currentViewFeed && Feed.currentViewFeed.feedId==id) {
		var show = $("div#"+id+"_viewfeed").css("display")=="none";
		if (show) {
			$("div#"+Feed.currentViewFeed.feedId+"_viewfeed").css("display","block");
			$("div#feed_"+Feed.currentViewFeed.feedId).css({"height":Feed.DROP_HEIGHT,"display":"block"});
		} else {
			$("div#"+Feed.currentViewFeed.feedId+"_viewfeed").css("display","none");
			$("div#feed_"+Feed.currentViewFeed.feedId).css({"height":Feed.NO_DROP_HEIGHT,"display":"block"});
		}
	}
}

Feed.deleteFeed=function(obj) {
	var id = Feed.getId(obj);
	feed = Feed.getFeedById(id);
	$('#delete_dialog_msg').empty().append("Do you want to delete the feed "+feed.title+" and all downloaded files?")
	Feed.deleteFunction=function() { Feed.doDelete(obj); }
	$('#delete_dialog').dialog('open');
}
Feed.save=function(obj) {
	var id = Feed.getId(obj);
	var feed = null;
	var callback = 0;
	if (id=='add') {
		if (!Feed.checked) {
			Feed.check(obj,true);
			return;
		}
		feed = Feed.addFeedTmp;
		callback = function() {
			Feed.setupAdd();
		}
	} else {
		feed = Feed.getFeedById(id);
	}
	Feed.updateFeedObject(feed,id);
	Feed.saveFeed(feed,callback);
}
Feed.updateFeedObject=function (feed,id) {
	var feedQuery = $("div#"+id+"_editfeed").children();
	feed.url = feedQuery.children("#"+id+"_efeed_url").val();
	feed.updInterval = feedQuery.children("#"+id+"_efeed_updinterval").val();
	feed.rating = feedQuery.children("#"+id+"_efeed_rating").val();
	feed.maxItems = feedQuery.children("#"+id+"_efeed_maxload").val();
	feed.numKeep = feedQuery.children("#"+id+"_efeed_numkeep").val();
	var autodl = feedQuery.children("#"+id+"_efeed_autodl").attr("checked");
	Feed.setFlag(feed,Feed.FLAG_MASK_DLAUTO,autodl);
	var dlp = feedQuery.children("#"+id+"_efeed_dlpower").attr("checked");
	Feed.setFlag(feed,Feed.FLAG_MASK_DLPWRCHK,dlp);
	var dlw = feedQuery.children("#"+id+"_efeed_dlwifi").attr("checked");
	Feed.setFlag(feed,Feed.FLAG_MASK_DLWIFICHK,dlw);
	feed.username = feedQuery.children("#"+id+"_efeed_user").val();
	feed.password = feedQuery.children("#"+id+"_efeed_pass").val();
	
}
Feed.cancelEdit=function(obj) {
	var id = Feed.getId(obj);
	if (id!='add') {
		//$("div#"+id+"_editfeed").empty();
		$("div#feed_"+id).css({"height":"130px"});
		$("div#"+id+"_editfeed").css("display","none");
	}else {
		Feed.setupAdd();
	}
}

Feed.check=function(obj,saveAfter) {
	var id = Feed.getId(obj);
	var feed = null;
	if (id=='add') {
		feed = Feed.addFeedTmp;
	} else {
		feed = Feed.getFeedById(id);
	}
	Feed.updateFeedObject(feed,id);
	
	var encoded = $.toJSON(feed);
	Util.showLoading();
	$("#"+id+"_efeed_url").css("disabled",true);
	$.post("?command=db&action=checkFeed",
		{feed:encoded},
		function(data) {
			if (data.feed && data.error.length==0) {
				// need to re-update the feed from the UI to 
				Feed.updateFeedObject(feed,id);
				if (data.feed.id>0) {
					feed.id=data.feed.id;
					feed.updInterval = data.feed.updInterval;
					feed.rating = data.feed.rating;
					feed.maxItems = data.feed.maxItems;
					feed.numKeep = data.feed.numKeep;
					feed.flags = data.feed.flags;
					feed.tags = data.feed.tags
				}
				feed.title = data.feed.title;
				feed.description = data.feed.description;
				feed.owner = data.feed.owner;
				feed.directory = data.feed.directory;
				feed.email = data.feed.email;
				feed.imgUrl = data.feed.imgUrl;
				feed.type = data.feed.type;
				feed.link = data.feed.link;
				feed.pubDate = data.feed.pubDate;
				Feed.refreshAdd();
				Feed.checked=true;
				if (saveAfter) {
					Feed.save(obj);
				}
			}
			if (data.error.length>0) {
				Util.showError(data.error);
			}
			$("#"+id+"_efeed_url").css("disabled",false);
			Util.hideLoading();
		},"json"
	);
}  
Feed.downloadFile=0;
Feed.downloadItemIndex=-1;
Feed.download=function(obj) {
	var ids=Feed.getFeedAndItemIndex(obj);
	var file = Feed.currentViewFeed.parsedFeed.files[ids[1]];
	Feed.downloadItemIndex=ids[1];
	Feed.downloadFile=file;
	var feed = Feed.getFeedById(ids[0]);
	file.feedId=feed.id;
	var dlContent=$("#download_content").children();
	dlContent.children("input#download_title_text").val(file.title);
	dlContent.children("span#download_url").empty().append(file.remoteUrl);
	dlContent.children("input#download_power_chk").val(true);
	File.getFlagIcons(file,dlContent.children("span#download_flags").empty());
	$("#download_dialog").dialog("open");
}
Feed.stream=function(obj,prefix) {
	var ids=Feed.getFeedAndItemIndex(obj);
	var file = Feed.currentViewFeed.parsedFeed.files[ids[1]];
	Feed.downloadFile=file;
	var feed = Feed.getFeedById(ids[0]);
	file.feedId=feed.id;
	Player.stream(file,prefix);
}
Feed.playItem=function(obj,prefix){
	var ids=Feed.getFeedAndItemIndex(obj);
	var file = Feed.currentViewFeed.parsedFeed.files[ids[1]];
	if (file) {
		var obj1={}
		obj1.id=file.id+"_tmp";
		Player.playFile(prefix,obj1);
	}
}
/////////////// end button handlers //////////////////////////



//////////////// add stuff ///////////////////////////////////
Feed.getFeedTemplate=function () {
	return {
		"id":-1,
		"imgUrl":"",
		"latestURL":"",
		"description":"",
		"newEntries":0,
		"rating":"1.0",
		"url":"",
		"numKeep":"1",
		"directory":"",
		"title":"",
		"updInterval":72,
		"files":[],
		"updLast":"",
		"link":"",
		"priority":0,
		"tags":[],
		"flags":0,
		"pubDate":"",
		"type":"rss",
		"maxItems":"-1",
		"email":"",
		"owner":""
		}
}
Feed.addFeedTmp={};
Feed.checked=0;
Feed.setupAdd = function () {
	Feed.checked=false;
	var clone = $("#editTmpl").children().clone();
	Feed.addFeedTmp = Feed.getFeedTemplate();
	Feed.populateEdit(clone,"add",Feed.addFeedTmp);
	$("div#add_editfeed").empty();
	clone.appendTo("div#add_editfeed");
}
Feed.refreshAdd = function () {
	//Feed.updateFeedObject(Feed.addFeedTmp,"add");
	var clone = $("#editTmpl").children().clone();
	Feed.populateEdit(clone,"add",Feed.addFeedTmp);
	$("div#add_editfeed").empty();
	clone.appendTo("div#add_editfeed");
}
/////////////// View feed //////////////////////////
Feed.currentViewFeed=0;
Feed.setCurrrentViewFeed=function(parsedFeed,feedId) {
	var fileLookupByUrl = {}
	if (parsedFeed) {
		for (var i =0;i<parsedFeed.files.length;i++) {
			fileLookupByUrl[parsedFeed.files[i].remoteUrl]=i;
		}
	}
	Feed.currentViewFeed={
		parsedFeed:parsedFeed,
		feedId:feedId,
		fileLookupByUrl:fileLookupByUrl
	}
}
Feed.parseAndRender=function(obj) {
	Util.hideLoading();
	Util.showMessage("Parsing ...");
	var parsedFeed = Parser.detectAndParse(AJAXLib.resultXML);
	if (parsedFeed) {
		Feed.setCurrrentViewFeed(parsedFeed,Feed.getId(obj));
		Feed.renderFeed(obj,parsedFeed);
	}else {
		Util.showMessage("Unable to load feed");
	}
}
Feed.clearViewFeed=function() {
	$("div#"+Feed.setCurrrentViewFeed.feedId+"_viewfeed").empty();
	Feed.currentViewFeed=0;
}
Feed.renderFeed=function(obj,parsedFeed) {
	var id = Feed.getId(obj);
	feed = Feed.getFeedById(id);
	$("div#"+id+"_viewfeed").empty();
	for (var i=0;i<parsedFeed.files.length;i++) {
		var itemIndex=i;
		var clone = $("#itemTmpl").children().clone();
		clone.attr("id",id+"_"+i+"_item_body");
		clone.children("span#_item_flags").attr("id",id+"_"+i+"_item_flags");
		clone.children().children("span#_item_title").attr("id",id+"_"+i+"_item_title").append(parsedFeed.files[i].title);
		clone.children().children("span#_item_pubdate").attr("id",id+"_"+i+"_item_pubdate").append(parsedFeed.files[i].pubDate);
		clone.children().children("a#_item_link").attr("id",id+"_"+i+"_item_link").attr("href",parsedFeed.files[i].link).append(parsedFeed.files[i].link);
		clone.children().children("a#_item_enclosure").attr("id",id+"_"+i+"_item_enclosure").attr("href",parsedFeed.files[i].remoteUrl).append(parsedFeed.files[i].remoteUrl);
		clone.children().children("span#_item_desc").attr("id",id+"_"+i+"_item_desc");//.attr("feedid",id).attr("itemIndex",i);
		clone.children().children("span#_item_status").attr("id",id+"_"+i+"_item_status");//.attr("feedid",id).attr("itemIndex",i);
		clone.children().children("span#_item_flags").attr("id",id+"_"+i+"_item_flags");//.attr("feedid",id).attr("itemIndex",i);
		clone.children().children("img#_item_dl_but").attr("id",id+"_"+i+"_item_dl_but");//.attr("feedid",id).attr("itemIndex",i);
		clone.children().children("img#_item_stfg_but").attr("id",id+"_"+i+"_item_stfg_but");//.attr("feedid",id).attr("itemIndex",i);
		clone.children().children("img#_item_stbg_but").attr("id",id+"_"+i+"_item_stbg_but");//.attr("feedid",id).attr("itemIndex",i);
		clone.children().children("img#_item_plfg_but").attr("id",id+"_"+i+"_item_plfg_but");//.attr("feedid",id).attr("itemIndex",i);
		clone.children().children("img#_item_plbg_but").attr("id",id+"_"+i+"_item_plbg_but");//.attr("feedid",id).attr("itemIndex",i);
		clone.children("div#_item_buttons").css("display",parsedFeed.files[i].remoteUrl?"block":"none");
		clone.appendTo("div#"+id+"_viewfeed");
	}
	$("div#feed_"+id).css({"height":Feed.DROP_HEIGHT,"display":"block"});
	$("div#"+id+"_viewfeed").css("display","block");
	Util.scrollToView("div#feed_"+id);
	Feed.checkFeedEntries(parsedFeed);
	Util.clearMessage();
}
Feed.checkFeedEntries=function(feed) {
	var fileUrls = new Array();
	for (var i=0;i<feed.files.length;i++) {
		fileUrls.push(feed.files[i].remoteUrl);
	}
	var encoded = $.toJSON(fileUrls);
	Util.showLoading();
	$.post("?command=db&action=checkFeedEntries",
		{urls:encoded},
		function(data){
			if (data.files && data.files.length>0) {
				//$.each(data.files, function(dfIndex) {	
				for (var dfIndex in data.files) {
					var file = data.files[dfIndex];
					var parsedFeedId = Feed.currentViewFeed.fileLookupByUrl[file.remoteUrl];
					Feed.currentViewFeed.parsedFeed.files[parsedFeedId]=file;
					var feedJQ=$("#"+Feed.currentViewFeed.feedId+"_"+parsedFeedId+"_item_body");
					var dlbut=$("#"+Feed.currentViewFeed.feedId+"_"+parsedFeedId+"_item_dl_but");
					var stfgbut=$("#"+Feed.currentViewFeed.feedId+"_"+parsedFeedId+"_item_stfg_but");
					var stbgbut=$("#"+Feed.currentViewFeed.feedId+"_"+parsedFeedId+"_item_stbg_but");
					var plfgbut=$("#"+Feed.currentViewFeed.feedId+"_"+parsedFeedId+"_item_plfg_but");
					var plbgbut=$("#"+Feed.currentViewFeed.feedId+"_"+parsedFeedId+"_item_plbg_but");
					var status=$("#"+Feed.currentViewFeed.feedId+"_"+parsedFeedId+"_item_status");
					status.append("(Rating:"+file.rating+" Listened:"+(parseInt(file.position)/100)+"%)");
					var flagsJQ = $("#"+Feed.currentViewFeed.feedId+"_"+parsedFeedId+"_item_flags");
					File.displayFlagIcons(file,flagsJQ);
					if (Feed.getFlag(file,File.FLAG_MASK_QUEUED)) {
						feedJQ.css("background","#440000");
					}
					if (Feed.getFlag(file,File.FLAG_MASK_DOWNLOADED)) {
						feedJQ.css("background","#004400");
					}
					if (Feed.getFlag(file,File.FLAG_MASK_LISTENED)) {
						feedJQ.css("background","#000044");
					}
					if (Feed.getFlag(file,File.FLAG_MASK_DOWNLOADED) && !Feed.getFlag(file,File.FLAG_MASK_DELETED) ) {
						stfgbut.css("display","none");
						stfgbut.next().css("display","none");
						stbgbut.css("display","none");
						stbgbut.next().css("display","none");
						plfgbut.css("display","inline");
						plfgbut.next().css("display","inline");
						plbgbut.css("display","inline");
						plbgbut.next().css("display","inline");
						dlbut.css("display","none");
						dlbut.next().css("display","none");
					} else{
						dlbut.css("display","inline");
						dlbut.next().css("display","inline");
					}
				}
				//});
			} 
			if (data.error.length>0) {
				Util.showError(data.error);
			}
			Util.hideLoading();
		},"json"
	);
}
Feed.getFeedAndItemIndex=function(obj) {
	var idstr=obj.id;
	return new Array(
		parseInt(idstr.substring(0,idstr.indexOf("_"))),
		parseInt(idstr.substring(idstr.indexOf("_")+1,idstr.indexOf("_",idstr.indexOf("_")+1)))
	);
}

Feed.viewDescription=function(obj) {
	var ids=Feed.getFeedAndItemIndex(obj);
	var feed = Feed.getFeedById(ids[0]);
	var item = Feed.currentViewFeed.parsedFeed.files[ids[1]];
	var desc = item.description;
	if (desc.indexOf(">")==-1) {
		desc=desc.replace(/\n/g,"<br/>");
	}
	$('#item_description_content').empty().append(desc)
	$('#item_description_content').find("a").attr("target","_blank");
	$('#item_description_dialog').dialog('open');
}


/////////////// end View feed ////////////////////////////


///////////////unused ////////////////////////////////////
/////////////// parsers //////////////////////////
/*
 Feed.check=function(obj) {
	var id = Feed.getId(obj);
	feed = Feed.getFeedById(id);
	if (id=='add') {
		feed = Feed.addFeedTmp;
	}
	var url = $("#"+id+"_efeed_url").val();
	
	$.get("?command=get", {url:url}, function(data) {
		var isRSS = $(data).parent().children("rss").size()==1;
		var isAtom = $(data).parent().children("feed").size()==1;
		if (isRSS) {
			Feed.parseRSS(data,feed);
			Feed.refreshAdd();
		} else {
			Feed.parseAtom(data,feed);
			Feed.refreshAdd();
		}
	});
}

Feed.parseRSS=function(data,feed) {
	var base = $(data).children("channel");
	feed.title=base.children("title").text( );
	feed.description=base.children("description").text( );
	feed.link=base.children("link").eq(0).text( );
	feed.pubDate=base.children("pubDate").text( );
	feed.imgUrl = base.children("image").eq(0).children("url").text();
	if (!feed.imgUrl) {
		feed.imgUrl = base.children("itunes:image").attr("href");
	}
	feed.type = "rss";
	feed.email = base.children("itunes:owner").eq(0).children("itunes:email").text(); 
	feed.owner = base.children("itunes:owner").eq(0).children("itunes:name").text(); 
}

Feed.parseAtom=function(data,feed) {
	
}
*/
/////////////// end parsers //////////////////////////