package org.digitalpropulsion.androidcalc;

import android.app.Activity;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.view.Menu.Item;
import android.view.View.OnKeyListener;
import android.util.DisplayMetrics;
import android.app.AlertDialog;
import android.text.method.KeyCharacterMap;

public class AndroidCalc extends Activity 
{
	private final String VERSION = "0.4";
	private final int MENUITEM_CLOSE = 200;
    private final int MENUITEM_ABOUT = 300;

    private EditText txtCalc;
    private Button btnZero;
	private Button btnOne;
    private Button btnTwo;
    private Button btnThree;
    private Button btnFour;
    private Button btnFive;
    private Button btnSix;
    private Button btnSeven;
    private Button btnEight;
    private Button btnNine;
    private Button btnPlus;
    private Button btnMinus;
    private Button btnMultiply;
    private Button btnDivide;
    private Button btnEquals;
    private Button btnC;
	private Button btnDecimal;
    private Button btnMC;
    private Button btnMR;
    private Button btnMM;
    private Button btnMP;
    private Button btnBS;
    private Button btnPerc;
    private Button btnSqrRoot;
    private Button btnPM;
    
	private double num = 0;
	private double memNum = 0;
    private int operator = 1; // 0 = nothing, 1 = plus, 2 = minus, 3 = multiply, 4 = divide
    private boolean readyToClear = false;
    private boolean hasChanged = false;
    
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle icicle) 
    {
        super.onCreate(icicle);
                
        setContentView(R.layout.main);
        
        this.setTitle("AndroidCalc");
        
        initControls();
        initScreenLayout();        
        reset();
        txtCalc.setSelection(1);
    }    
    
	@Override
	public boolean onCreateOptionsMenu(Menu menu) 
	{
		menu.add(1, MENUITEM_ABOUT, "About");
		menu.add(2, MENUITEM_CLOSE, "Close");

		return super.onCreateOptionsMenu(menu);
	}

	@Override
	public boolean onOptionsItemSelected(Item item) 
	{
		switch (item.getId())
		{
			case MENUITEM_ABOUT:
				AlertDialog.show(this.getWindow().getContext(), null, 0, "AndroidCalc v"+ VERSION +"\nby Adam Plocher\nwww.digitalpropulsion.org", "Close", false);
				break;
				
			case MENUITEM_CLOSE:
				finish();
				break;
		}	
		
		return super.onOptionsItemSelected(item);
	}
    
    private void initScreenLayout()
    {
    	//480 x 320 (Wide Display - HVGA-L)
        //320 x 480 (Tall Display - HVGA-P) [default]
    	//320 x 240 (Short Display - QVGA-L)
        //240 x 320 (Short Display - QVGA-P) 
    	
    	DisplayMetrics dm = new DisplayMetrics();
        getWindowManager().getDefaultDisplay().getMetrics(dm);
        
        //this.showAlert(dm.widthPixels +" "+ dm.heightPixels, dm.widthPixels +" "+ dm.heightPixels, dm.widthPixels +" "+ dm.heightPixels, false);

        int height = dm.heightPixels;
        int width = dm.widthPixels;
        
        if (height < 400 || width < 300)
        {
        	txtCalc.setTextSize(20);
        	
        	btnMC.setTextSize(18);
        	btnMR.setTextSize(18);
        	btnMP.setTextSize(18);
        	btnMM.setTextSize(18);
        	btnBS.setTextSize(18);
        	btnDivide.setTextSize(18);
        	btnPlus.setTextSize(18);
        	btnMinus.setTextSize(18);
        	btnMultiply.setTextSize(18);
        	btnEquals.setTextSize(18);
        	btnPM.setTextSize(18);
        	btnPerc.setTextSize(18);
        	btnC.setTextSize(18);
        	btnSqrRoot.setTextSize(18);
        	btnNine.setTextSize(18);
        	btnEight.setTextSize(18);
        	btnSeven.setTextSize(18);
        	btnSix.setTextSize(18);
        	btnFive.setTextSize(18);
        	btnFour.setTextSize(18);
        	btnThree.setTextSize(18);
        	btnTwo.setTextSize(18);
        	btnOne.setTextSize(18);
        	btnZero.setTextSize(18);
        	btnDecimal.setTextSize(18);
        }

        btnZero.setTextColor(0xFF3399FF);
        btnOne.setTextColor(0xFF3399FF);
        btnTwo.setTextColor(0xFF3399FF);
        btnThree.setTextColor(0xFF3399FF);
        btnFour.setTextColor(0xFF3399FF);
        btnFive.setTextColor(0xFF3399FF);
        btnSix.setTextColor(0xFF3399FF);
        btnSeven.setTextColor(0xFF3399FF);
        btnEight.setTextColor(0xFF3399FF);
        btnNine.setTextColor(0xFF3399FF);
        btnPM.setTextColor(0xFF3399FF);
        btnDecimal.setTextColor(0xFF3399FF);
        
        btnMP.setTextColor(0xFFAAAAAA);
        btnMM.setTextColor(0xFFAAAAAA);
        btnMR.setTextColor(0xFFAAAAAA);
        btnMC.setTextColor(0xFFAAAAAA);
        btnBS.setTextColor(0xFFAAAAAA);
        btnC.setTextColor(0xFFAAAAAA);
    	btnPerc.setTextColor(0xFFAAAAAA);
    	btnSqrRoot.setTextColor(0xFFAAAAAA);
    }
    
    private void initControls()
    {
        txtCalc = (EditText)findViewById(R.id.txtCalc);
        btnZero = (Button)findViewById(R.id.btnZero);
        btnOne = (Button)findViewById(R.id.btnOne);
        btnTwo = (Button)findViewById(R.id.btnTwo);
        btnThree = (Button)findViewById(R.id.btnThree);
        btnFour = (Button)findViewById(R.id.btnFour);
        btnFive = (Button)findViewById(R.id.btnFive);
        btnSix = (Button)findViewById(R.id.btnSix);
        btnSeven = (Button)findViewById(R.id.btnSeven);
        btnEight = (Button)findViewById(R.id.btnEight);
        btnNine = (Button)findViewById(R.id.btnNine);
        btnPlus = (Button)findViewById(R.id.btnPlus);
        btnMinus = (Button)findViewById(R.id.btnMinus);
        btnMultiply = (Button)findViewById(R.id.btnMultiply);
        btnDivide = (Button)findViewById(R.id.btnDivide);
        btnEquals = (Button)findViewById(R.id.btnEquals);
        btnC = (Button)findViewById(R.id.btnC);
        btnDecimal = (Button)findViewById(R.id.btnDecimal);
        btnMC = (Button)findViewById(R.id.btnMC);
        btnMR = (Button)findViewById(R.id.btnMR);
        btnMM = (Button)findViewById(R.id.btnMM);
        btnMP = (Button)findViewById(R.id.btnMP);
        btnBS = (Button)findViewById(R.id.btnBS);
        btnPerc = (Button)findViewById(R.id.btnPerc);
        btnSqrRoot = (Button)findViewById(R.id.btnSqrRoot);
        btnPM = (Button)findViewById(R.id.btnPM);

        btnZero.setOnClickListener(new Button.OnClickListener() { public void onClick (View v){ handleNumber(0); }});
        btnOne.setOnClickListener(new Button.OnClickListener() { public void onClick (View v){ handleNumber(1); }});
        btnTwo.setOnClickListener(new Button.OnClickListener() { public void onClick (View v){ handleNumber(2); }});
        btnThree.setOnClickListener(new Button.OnClickListener() { public void onClick (View v){ handleNumber(3); }});
        btnFour.setOnClickListener(new Button.OnClickListener() { public void onClick (View v){ handleNumber(4); }});
        btnFive.setOnClickListener(new Button.OnClickListener() { public void onClick (View v){ handleNumber(5); }});
        btnSix.setOnClickListener(new Button.OnClickListener() { public void onClick (View v){ handleNumber(6); }});
        btnSeven.setOnClickListener(new Button.OnClickListener() { public void onClick (View v){ handleNumber(7); }});
        btnEight.setOnClickListener(new Button.OnClickListener() { public void onClick (View v){ handleNumber(8); }});
        btnNine.setOnClickListener(new Button.OnClickListener() { public void onClick (View v){ handleNumber(9); }});
        btnPlus.setOnClickListener(new Button.OnClickListener() { public void onClick (View v){ handleEquals(1); }});
        btnMinus.setOnClickListener(new Button.OnClickListener() { public void onClick (View v) { handleEquals(2); }});
        btnMultiply.setOnClickListener(new Button.OnClickListener() { public void onClick (View v){ handleEquals(3); }});
        btnDivide.setOnClickListener(new Button.OnClickListener() { public void onClick (View v){ handleEquals(4); }});
        btnEquals.setOnClickListener(new Button.OnClickListener() { public void onClick (View v){ handleEquals(0); }});
        btnC.setOnClickListener(new Button.OnClickListener(){ public void onClick (View v){ reset(); }});
        btnDecimal.setOnClickListener(new Button.OnClickListener() { public void onClick (View v){ handleDecimal(); }});
        btnPM.setOnClickListener(new Button.OnClickListener(){ public void onClick (View v) { handlePlusMinus(); }});
        btnMC.setOnClickListener(new Button.OnClickListener(){ public void onClick (View v){ memoryClear(); }});
        btnMR.setOnClickListener(new Button.OnClickListener(){ public void onClick (View v){ memoryRecall(); }});
        btnMM.setOnClickListener(new Button.OnClickListener(){ public void onClick (View v){ memorySubtract(); }});
        btnMP.setOnClickListener(new Button.OnClickListener(){ public void onClick (View v){ memoryAdd(); }});
        btnBS.setOnClickListener(new Button.OnClickListener(){ public void onClick (View v){ handleBackspace();}});
        btnSqrRoot.setOnClickListener(new Button.OnClickListener(){ public void onClick (View v){ setValue(Double.toString(Math.sqrt(Double.parseDouble(txtCalc.getText().toString())))); }});
        btnPerc.setOnClickListener(new Button.OnClickListener() { public void onClick (View v){ handlePercent(); }});        
                
        txtCalc.setOnKeyListener(new OnKeyListener()
        {
        	public boolean onKey(View v, int i, android.view.KeyEvent e)
        	{
    			int keyCode = e.getKeyCode();

    			if (keyCode == KeyEvent.KEYCODE_SOFT_LEFT)
    				return false;
				
        		if (e.getAction() == android.view.KeyEvent.ACTION_DOWN)
        		{
					KeyCharacterMap keyMap = KeyCharacterMap.load(KeyCharacterMap.BUILT_IN_KEYBOARD);
					int c = keyMap.get(keyCode, KeyEvent.META_ALT_ON);

					boolean proceed = true;
					
					// First check for numbers on the ALT key
					// The reason why we check these numbers first instead of doing the check at the same time (see the third check),
					// is because certain layouts like the QVGA-L which comes with the android emulator have the numbers as ALT keys.
					// For example, the number 8 is on the X key.  The X key can be used for multiplication, but it's probably more important
					// that the number works, instead of the X.  Numbers take priority over anything else.
					if (c != 0)
					{
						proceed = false;
						switch ((char)c)
						{
							case '0': handleNumber(0); break;
							case '1': handleNumber(1); break;
							case '2': handleNumber(2); break;
							case '3': handleNumber(3); break;
							case '4': handleNumber(4); break;
							case '5': handleNumber(5); break;
							case '6': handleNumber(6); break;
							case '7': handleNumber(7); break;
							case '8': handleNumber(8); break;
							case '9': handleNumber(9); break;
							default: 
								proceed = true; 
								break;
						}
					}
					
					// Second check the keycode for numbers, operators, etc
					if (proceed)
					{
						proceed = false;
						
	    				switch (keyCode)
	    				{
	    					case KeyEvent.KEYCODE_0: handleNumber(0); break;
	    					case KeyEvent.KEYCODE_1: handleNumber(1); break;
	    					case KeyEvent.KEYCODE_2: handleNumber(2); break;
		    				case KeyEvent.KEYCODE_3: handleNumber(3); break;
		    				case KeyEvent.KEYCODE_4: handleNumber(4); break;
		    				case KeyEvent.KEYCODE_5: handleNumber(5); break;
		    				case KeyEvent.KEYCODE_6: handleNumber(6); break;
		    				case KeyEvent.KEYCODE_7: handleNumber(7); break;
		    				case KeyEvent.KEYCODE_8: handleNumber(8); break;
		    				case KeyEvent.KEYCODE_9: handleNumber(9); break;
		    				case KeyEvent.KEYCODE_EQUALS: handleEquals(0); break;
		    				case KeyEvent.KEYCODE_PLUS: handleEquals(1); break;
		    				case KeyEvent.KEYCODE_MINUS: handleEquals(2); break;
		    				case KeyEvent.KEYCODE_STAR: case KeyEvent.KEYCODE_X: handleEquals(3); break;
		    				case KeyEvent.KEYCODE_SLASH: handleEquals(4); break;
		    				case KeyEvent.KEYCODE_PERIOD: handleDecimal(); break;
		    				case KeyEvent.KEYCODE_C: reset(); break;
		    				case KeyEvent.KEYCODE_DPAD_LEFT: case KeyEvent.KEYCODE_DEL: handleBackspace(); break;
		    				case KeyEvent.KEYCODE_DPAD_DOWN: return false;
		    					
		    				default:
	    						proceed = true;
		    					break;
	    				}
	        		}
					
					// Third and finally, check for operators that are an ALT key
					if (proceed)
					{
    					switch ((char)c)
    					{
    						case '=': handleEquals(0); break;
    						case '+': handleEquals(1); break;
    						case '-': handleEquals(2); break;
    						case '*': handleEquals(3); break;
    						case '/': case '\\': handleEquals(4); break;
    						case '.': handleDecimal(); break;
    						case '%': handlePercent(); break;
    					}
					}
        		}
        		
        		return true;
        	}
        });    
    }
    
    private void handleEquals(int newOperator)
    {
    	if (hasChanged)
    	{
	    	switch (operator)
	    	{
		    	case 1:
			    	num = num + Double.parseDouble(txtCalc.getText().toString());
					break;
		    	case 2:
		    		num = num - Double.parseDouble(txtCalc.getText().toString());
		    		break;
		    	case 3:
		    		num = num * Double.parseDouble(txtCalc.getText().toString());
		    		break;
		    	case 4:
		    		num = num / Double.parseDouble(txtCalc.getText().toString());
		    		break;
	    	}
	    	
	    	String txt = Double.toString(num);
	    	txtCalc.setText(txt);
	    	txtCalc.setSelection(txt.length());
	    	
			readyToClear = true;
			hasChanged = false;
    	}
    	
    	operator = newOperator;
    }
    
    private void handleNumber(int num)
    {
    	if (operator == 0)
    		reset();
    	
    	String txt = txtCalc.getText().toString();
		if (readyToClear)
		{
			txt = "";
			readyToClear = false;
		}
		else if (txt.equals("0"))
			txt = "";
		
		txt = txt + Integer.toString(num);
		
		txtCalc.setText(txt);
		txtCalc.setSelection(txt.length());
		
		hasChanged = true;
    } 
    
    private void setValue(String value)
    {
    	if (operator == 0)
    		reset();
    	
    	if (readyToClear)
    		readyToClear = false;
    	
    	txtCalc.setText(value);
		txtCalc.setSelection(value.length());
		
		hasChanged = true;
    }
    
    private void handleDecimal()
    {
    	if (operator == 0)
    		reset();
    	
    	if (readyToClear)
    	{
    		txtCalc.setText("0.");
    		txtCalc.setSelection(2);
    		readyToClear = false;
    		hasChanged = true;
    	}
    	else 
    	{
    		String txt = txtCalc.getText().toString();
    		
    		if (!txt.contains("."))
    		{
    			txtCalc.append(".");
    			txtCalc.setSelection(txtCalc.getText().length());
    			hasChanged = true;
    		}
    	}
    }
    
    private void handlePercent()
    {
    	setValue(Double.toString(num * (0.01 * Double.parseDouble(txtCalc.getText().toString()))));
    	readyToClear = true;
    }
    
    private void handleBackspace()
    {
    	if (!readyToClear)
    	{
	    	String txt = txtCalc.getText().toString();
	    	if (txt.length() > 0)
	    	{
	    		txt = txt.substring(0, txt.length() - 1);
	    		if (txt.equals(""))
	    			txt = "0";
	    		
	    		txtCalc.setText(txt);
	    		txtCalc.setSelection(txt.length());
	    	}
    	}
    }
    
    private void handlePlusMinus()
    {
    	if (!readyToClear)
    	{
	    	String txt = txtCalc.getText().toString();
	    	if (!txt.equals("0"))
	    	{
	        	if (txt.charAt(0) == '-')
	        		txt = txt.substring(1, txt.length());
	        	else
	        		txt = "-" + txt;
	        	
	        	txtCalc.setText(txt);
	        	txtCalc.setSelection(txt.length());
	    	}
    	}
    }
    
    private void reset()
    {
		num = 0;
		txtCalc.setText("0");
		txtCalc.setSelection(1);
		operator = 1;
    }
    
    private void memoryAdd()
    {
    	memNum = memNum + Double.parseDouble(txtCalc.getText().toString()); 
    	operator = 0;
    }
    
    private void memorySubtract()
    {
    	memNum = memNum - Double.parseDouble(txtCalc.getText().toString()); operator = 0;
    }
    
    private void memoryClear()
    {
    	memNum = 0;
    }
    
    private void memoryRecall()
    {
    	setValue(Double.toString(memNum)); 
    	readyToClear = true;
    }
}
